<?php

namespace apexl\Io\includes;

use apexl\ClassEngine\EngineSingleton;

class moduleStore extends EngineSingleton
{
    /** @var array<string, Entity[]> */
    protected static array $entities;

    public function add(string $module, Entity $entity): void
    {
        self::$entities[$module][] = $entity;
    }

    /**
     * @return Entity[]
     */
    public function all(string $module, ?string $type = null): array
    {
        $entities = self::$entities[$module] ?? [];

        if ($type) {
            $entities = array_filter(
                $entities,
                fn(Entity $entity) => is_a($entity, $type)
            );
        }

        return $entities;
    }

}
