<?php

namespace apexl\Io\modules\BasicDisplay;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\BasicApi\Services\BasicModuleEntityStore;
use apexl\Io\modules\display\controllers\DisplayController;
use apexl\Io\modules\display\controllers\formsController;
use apexl\Io\modules\menu\interfaces\ProvidesMenuItemsInterface;
use apexl\Io\modules\menu\services\MenuManager;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\modules\user\enums\permissions\Common;
use apexl\Io\services\InstallChecker;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class BasicDisplayModule extends userManagedDisplayModule implements ProvidesMenuItemsInterface, ProvidesRoutesInterface
{
    public function __construct(
        protected BasicModuleEntityStore $moduleStore,
        InstallChecker $installChecker,
    ) {
        parent::__construct($installChecker);
    }

    /**
     * @Todo - Refine permissions. For now, using Core ENUMs
     */
    public function routes(RouteManager $routeManager): void
    {
        if ($entities = $this->moduleStore->all($this->moduleStoreKey())) {
            foreach ($entities as $entity) {
                $this->addProtectedEntityRoutes($routeManager, $entity, [
                    'all' => [DisplayController::class . ':all', Common::VIEW],
                    'get' => [DisplayController::class . ':view', Common::VIEW],
                    'put' => [DisplayController::class . ':create', Common::UPDATE],
                    'post' => [DisplayController::class . ':create', Common::CREATE],
                    'delete' => [DisplayController::class . ':delete', Common::DELETE],
                ]);

                //add Form Route
                $this->addProtectedEntityFormRoute(
                    $routeManager,
                    $entity,
                    $entity->getEntityName() . '/createUpdate[/{id}]',
                    formsController::class . ':entityCreateUpdate',
                );
            }
        }
    }

    protected function moduleStoreKey(): string
    {
        return $this::class;
    }

    public function menuItems(MenuManager $menuManager): void
    {
        if ($entities = $this->moduleStore->all($this->moduleStoreKey())) {
            foreach ($entities as $entity) {
                $menuManager->addToMenu($entity->getEntityName() . '.adminParent', [
                    'title' => $entity->getNiceName(),
                ], 'administration');
                $menuManager->addToMenu($entity->getEntityName() . '.display.all', [
                    'title' => 'View List',
                    'parent' => $entity->getEntityName() . '.adminParent',
                ], 'administration');
                $menuManager->addToMenu($entity->getEntityName() . '.display.post', [
                    'title' => 'Create',
                    'parent' => $entity->getEntityName() . '.adminParent',
                ], 'administration');
            }
        }
    }
}
