<?php

namespace apexl\Io\modules\basicDisplay;

use apexl\Io\includes\Entity;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\display\controllers\formsController;
use apexl\Io\includes\moduleStore;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\traits\hasEntityStore;
use Closure;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class basicDisplayModule extends userManagedDisplayModule
{
    use hasEntityStore;

    protected moduleStore $moduleStore;

    public function __construct()
    {
        parent::__construct();

        $this->moduleStore = moduleStore::getInstance();
        $this->storeEntities(func_get_args());
    }

    public function routes(): void
    {
        $this->entitiesRoutes();
    }

    private function entityRoutes(Entity $entity): void
    {
        $entityName = $entity->getEntityName();
        $this->addProtectedEntityRoutes($entity, $this->entityRoutesArray($entity));

        //add Form Route
        $this->addProtectedEntityFormRoute(
            $entity,
            sprintf('%s/createUpdate[/{id}]', $entityName),
            sprintf('%s:entityCreateUpdate', $this->entityFormControllerClass($entity)),
            sprintf('Update%s', $entityName)
        );
    }

    protected function entityRoutesArray(Entity $entity): array
    {
        return [
            'all' => $this->entityRoute($entity, 'all', 'View'),
            'get' => $this->entityRoute($entity, 'view'),
            'put' => $this->entityRoute($entity, 'create', 'Update'),
            'post' => $this->entityRoute($entity, 'create', 'Create'),
            'delete' => $this->entityRoute($entity, 'delete', 'Delete'),
        ];
    }

    protected function entityRoute(Entity $entity, string $method, ?string $prefix = null): array
    {
        $prefix = $prefix ?? ucfirst($method);

        return [
            sprintf('%s:%s', $this->displayControllerClass($entity), $method),
            sprintf('%s%s', $prefix, $entity->getEntityName()),
        ];
    }

    /** @noinspection PhpUnused */
    public function registerMenuItems(): void
    {
        $this->eachEntity(Closure::fromCallable([$this, 'entityMenuItems']));
    }

    private function entityMenuItems(Entity $entity): void
    {
        $entityName = $entity->getEntityName();

        Menu::addToMenu(
            sprintf('%s.adminParent', $entityName),
            [
                'title' => $entity->getNiceName(),
            ],
            'administration'
        );

        Menu::addToMenu(
            sprintf('%s.display.all', $entityName),
            [
                'title' => 'View List',
                'parent' => sprintf('%s.adminParent', $entityName),
            ],
            'administration'
        );

        Menu::addToMenu(
            sprintf('%s.display.post', $entityName),
            [
                'title' => 'Create',
                'parent' => sprintf('%s.adminParent', $entityName),
            ],
            'administration'
        );
    }

    /** @noinspection PhpUnusedParameterInspection */
    protected function displayControllerClass(Entity $entity): string
    {
        return displayController::class;
    }

    protected function entityFormControllerClass(Entity $entity): string
    {
        return formsController::class;
    }
}
