<?php declare(strict_types=1);

namespace apexl\Io\traits;

use apexl\Io\includes\Entity;
use apexl\Io\includes\moduleStore;
use Closure;

trait hasEntityStore
{
    protected moduleStore $moduleStore;

    abstract protected function getName();
    abstract protected function entityRoutes(Entity $entity): void;

    protected function storeEntities(array $args)
    {
        foreach ($args as $arg) {
            if (is_subclass_of($arg, Entity::class)) {
                $this->moduleStore::addEntityToStore($this->getName(), $arg);
            }
        }
    }

    protected function entitiesRoutes(): void
    {
        $this->eachEntity(fn(Entity $entity) => $this->entityRoutes($entity));
    }

    protected function eachEntity(Closure $callback): void
    {
        if ($entities = $this->moduleStore::getModuleEntities($this->getName())) {
            array_walk($entities, $callback);
        }
    }



}
