<?php

namespace apexl\Io\modules\bundleBuilder;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\modules\bundleBuilder\controllers\bundleBuilderController;
use apexl\Io\modules\bundleBuilder\controllers\bundleBuilderHookController;
use apexl\Io\modules\bundleBuilder\entities\bundleConfigurationEntity;
use apexl\Io\modules\user\services\Permissions;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class bundleBuilderModule extends Module {

    public function __construct()
    {
        parent::__construct();
        $this->registerHooks();
        $this->permissions();
    }

    public function routes(){
        //data routes
        $this->route->get('/api/bb/bundle/{id}', bundleBuilderController::class.':getBundle', 'BundleBuilder');
        $this->route->get('/api/bb/bundle', bundleBuilderController::class.':getBundle', 'BundleBuilder');

        $this->route->get('/api/bb/customer/configuration/{id}', bundleBuilderController::class.':getConfiguration', 'BundleBuilder');
        $this->route->get('/api/bb/customer/{id}', bundleBuilderController::class.':getCustomer', 'BundleBuilder');
        $this->route->get('/api/bb/customer', bundleBuilderController::class.':getCustomer', 'BundleBuilder');

        $this->route->get('/api/bb/calculation', bundleBuilderController::class.':getCalculationByCustomer', 'BundleBuilder');

        $this->route->post('/api/bb/files/upload-cdr', bundleBuilderController::class.':uploadCDR', 'BundleBuilder');
        $this->route->post('/api/bb/process-cdr/{id}', bundleBuilderController::class.':processCDRUpload', 'BundleBuilder');

        $this->route->post('/api/bb/customer/configuration/{id}', bundleBuilderController::class.':storeConfiguration', 'BundleBuilder');
        $this->route->post('/api/bb/customer/configuration', bundleBuilderController::class.':storeConfiguration', 'BundleBuilder');
        $this->route->post('/api/bb/customer/{id}', bundleBuilderController::class.':storeCustomer', 'BundleBuilder');
        $this->route->post('/api/bb/customer', bundleBuilderController::class.':storeCustomer', 'BundleBuilder');
    }

    protected function permissions(){
        $permissions = Permissions::getInstance();
        $permissions->registerPermission('BundleBuilder', 'Use the Bundle Builder', 'Bundle Builder');
    }

    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    public function install(){
        //set some default configs
        $config = new bundleConfigurationEntity();
        $config->Customer = 0;
        $config->DataPerMonth = 5;
        $config->TotalOutboundSMSPerMonth = 1;
        $config->TotalInboundSMSPerMonth = 1;
        $config->TotalVoiceMinutesPerMonth = 1;
        $config->SIMsBillableRate = 0.69;
        $config->OverageDataRate = 0.07;
        $config->OverageSMSMORate = 0.07;
        $config->OverageSMSMTRate = 0.01;
        $config->OverageVoiceRate = 0.07;
        $config->store();
    }

    public function registerHooks(){
        Hook::registerCallback('getEntityData', bundleBuilderHookController::class.':getEntityDataAlter');
    }
}