<?php

namespace apexl\Io\modules\bundleBuilder\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\bundleBuilder\entities\bundleCalculationsEntity;
use apexl\Io\modules\bundleBuilder\entities\bundleConfigurationEntity;
use apexl\Io\modules\bundleBuilder\entities\bundleEntity;
use apexl\Io\modules\bundleBuilder\entities\jasperCustomerEntity;
use apexl\Io\modules\file\services\File;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class bundleBuilderController extends Controller {

    protected $file;
    protected $currentUser;
    protected $menu;

    public function __construct(currentUser $currentUser, File $file){
        parent::__construct();
        $this->currentUser = $currentUser::getCurrentUser();
        $this->file = $file;
    }

    public function uploadCDR(Request $request, Response $response){
        $fileEntity = $this->file::getFileFromUpload($request);
        //Check we have a file we're allowed to upload and store, if not, throw an error
        if(!$this->file::isTypeAllowed($fileEntity->mime, $this->file::defaultAllowedTypes())){
            return System::asJson($response, System::output(['type' => 'error', 'content' => '403 file type of '.$fileEntity->mime.' not allowed']));
        }

        $path = $this->file::storeUploadedFile($fileEntity->getMetadata('uploadedFile'));
        $fileEntity->path = $path;
        $fileEntity->store();

        //new CDR so create a bundle.
        $bundleEntity = new bundleEntity();
        $bundleEntity->file = $fileEntity->id;
        $bundleEntity->createdDate = time();
        $bundleEntity->createdBy = $this->currentUser->id;
        $bundleEntity->store();

        //next, run the cdr process and then redirect to the CDR page, with a success message
        try {
            $bundleEntity->processBundle();
            return System::asJson($response, System::output(['type' => 'success', 'content' => 'New CDR created.'], '/bundleBuilder/bundles/'.$bundleEntity->id));
        } catch (\Exception $e) {
            return System::asJson($response, System::output(['type' => 'error', 'content' => 'Something went wrong when processing the CDR. Message:'.$e->getMessage()], '/bundleBuilder/bundles'), 500);
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     * @throws \Exception
     */
    public function processCDRUpload(Request $request, Response $response, $args){
        $bundle = new bundleEntity();
        $bundle->load($args['id']);
        if(!isset($bundle->id)){
            return System::asJson($response, System::output(['type' => 'error', 'content' => 'Bundle not found']), 404);
        }

        try {
            $bundle->processBundle();
            return System::asJson($response, System::output(['type' => 'success', 'content' => 'New CDR created.'], '/bundleBuilder/bundles/'.$bundle->id));
        } catch (\Exception $e) {
            return System::asJson($response, System::output(['type' => 'error', 'content' => 'Something went wrong when processing the CDR. Message:'.$e->getMessage()], '/bundleBuilder/bundles'), 500);
        }
    }

    /**
     * Function to load one bundle, or all of them.
     * @param Request $request
     * @param Response $response
     * @param $args
     * @return Response
     */
    public function getBundle(Request $request, Response $response, $args){
        return $this->getEntityData($request, $response, $args, (new bundleEntity()));
    }

    public function getCustomer(Request $request, Response $response, $args){
        return $this->getEntityData($request, $response, $args, (new jasperCustomerEntity()));
    }

    public function getCalculationByCustomer(Request $request, Response $response, $args){
        return $this->getEntityData($request, $response, $args, (new bundleCalculationsEntity()));
    }

    public function getConfiguration(Request $request, Response $response, $args){
        return $this->getEntityData($request, $response, $args, (new bundleConfigurationEntity()));
    }

    public function storeCustomer(Request $request, Response $response, $args){
        return $this->setEntityData($request, $response, $args, (new jasperCustomerEntity()));
    }

    public function storeConfiguration(Request $request, Response $response, $args){
        //if we have a customer ID this is not global config, so we need to unset the ID in args if its 1.
        $body = $request->getParsedBody();
        if($args['id'] == 1 && $body->Customer != 0){
            unset($args['id']);
        }
        return $this->setEntityData($request, $response, $args, (new bundleConfigurationEntity()));
    }
}