<?php
namespace apexl\Io\modules\bundleBuilder\controllers;

use apexl\Io\modules\bundleBuilder\entities\bundleEntity;
use apexl\Io\modules\bundleBuilder\entities\jasperCustomerEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\services\pathUtility;
use apexl\Utils\Maths\General;

class bundleBuilderHookController {

    /**
     * HOOK getEntityData
     * All entity data returned by this hook is pages, so looping for post processing should be relatively safe
     * @param $entityData
     * @param $entityName
     */
    public static function getEntityDataAlter($entityData, $entityName){
        switch($entityName){
            case 'bundleEntity':
                //we need to change the table headers.
                $entityData['tableHeader'] = [
                    'Bundle ID',
                    'Customers in CDR',
                    'Customers Processed',
                    'CDR Uploaded',
                    'Uploaded by'
                ];

                $alteredRows = [];
                foreach($entityData['rows'] as $entityID => $row){
                    //keep the key to preserve order
                    $alteredRows[$entityID] = $row;
                    //remove the file column
                    unset($alteredRows[$entityID]['file']);
                    //set the date to a readable format
                    $alteredRows[$entityID]['createdDate'] = date('d-m-Y H:i:s', $row['createdDate']);
                    //load the user instead of the id
                    $user = new userEntity();
                    $user->load($row['createdBy']);
                    $alteredRows[$entityID]['createdBy'] = $user->getNiceName();
                }
                $entityData['rows'] = $alteredRows;
                break;
            case 'bundleCalculationsEntity':
                $path = pathUtility::getInstance();
                $url = $path->getPath(FALSE, TRUE);
                //we need to change the table headers.
                $entityData['tableHeader'] = [
                    'Customer',
                    'Date',
                    'Total Sims',
                    'Active Sims',
                    'Subscription<br/>Charge',
                    'Data',
                    'Data<br/>Overage',
                    'SMS<br/>(msg)',
                    'SMS<br/>MO (msg)',
                    'SMS<br/>MT (msg)',
                    'SMS MO<br/>Overage',
                    'SMS MT<br/>Overage',
                    'Voice<br/>(mins)',
                    'Voice<br/>MT (mins)',
                    'Voice<br/>MO (mins)',
                    'Voice MO<br/>Overage',
                    'Total<br/>Charge',
                ];

                if(strpos($url, 'bundleId=') !== FALSE){
                    //this is the single bundle view, we dont need to show the date.
                    unset($entityData['tableHeader'][1]);
                }

                //no need to show customer Name on customer pages
                if(strpos($url, 'customerId=') !== FALSE){
                    unset($entityData['tableHeader'][0]);
                }
                $alteredRows = [];
                foreach($entityData['rows'] as $entityID => $row){
                    //get the bundle ID and thus the date, to use instead of the ID.
                    $bundle = new bundleEntity();
                    $bundle->load($row['bundleId']);

                    //keep the key to preserve order
                    $alteredRows[$entityID] = $row;
                    //remove bundle and customer ids
                    $alteredRows[$entityID] = ['date' => '<small>'.date('d-m-Y', $bundle->createdDate).'</small>'] + $alteredRows[$entityID];
                    $alteredRows[$entityID]['id'] = $alteredRows[$entityID]['customerId'];
                    unset($alteredRows[$entityID]['bundleId']);
                    unset($alteredRows[$entityID]['VoiceMTVolumeOverage']);
                    unset($alteredRows[$entityID]['billedFor']);
                    unset($alteredRows[$entityID]['subCharge']);
                    unset($alteredRows[$entityID]['InvoiceId']);
                    if(strpos($url, 'customerId=') !== FALSE){
                        unset($alteredRows[$entityID]['customerId']);
                    } else {
                        $customer = new jasperCustomerEntity();
                        $customer->load($alteredRows[$entityID]['customerId']);
                        unset($alteredRows[$entityID]['customerId']);
                        $alteredRows[$entityID] = ['customerId' => $customer->CustomerName] + $alteredRows[$entityID];
                    }

                    if(strpos($url, 'bundleId=') !== FALSE){
                        //this is the single bundle view, we dont need to show the date.
                        unset($alteredRows[$entityID]['date']);
                    }
                    //set column units and trim the numbers to 2 DP.
                    $alteredRows[$entityID]['SubscriptionCharge'] = '£'.number_format($row['SubscriptionCharge'], 2);
                    //convert MB to bytes
                    $alteredRows[$entityID]['DataVolume'] = General::formatBytes(($row['DataVolume'] * 1048576));
                    $alteredRows[$entityID]['DataVolumeOverage'] = '£'.number_format($row['DataVolumeOverage'], 2);
                    $alteredRows[$entityID]['SMSMOVolumeOverage'] = '£'.number_format($row['SMSMOVolumeOverage'], 2);
                    $alteredRows[$entityID]['SMSMTVolumeOverage'] = '£'.number_format($row['SMSMTVolumeOverage'], 2);
                    $alteredRows[$entityID]['VoiceMOVolumeOverage'] = '£'.number_format($row['VoiceMOVolumeOverage'], 2);
                    $alteredRows[$entityID]['TotalCharge'] = '£'.number_format($row['TotalCharge'], 2);
                }
                $entityData['rows'] = $alteredRows;
                break;
        }
        return $entityData;
    }
}