<?php

namespace apexl\Io\modules\bundleBuilder\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\bundleBuilder\entities\operators\calculationsOperator;

class bundleCalculationsEntity extends Entity{

    protected $customer;
    protected $bundle;
    protected $totals;
    protected $costs;

    public function __construct(jasperCustomerEntity $customerEntity = NULL, bundleEntity $bundle = NULL)
    {
        parent::__construct('bundleBuilderCalculations');
        $this->setOperator(new calculationsOperator('bundleBuilderCalculations'));
        $this->customer = $customerEntity;
        $this->bundle = $bundle;
        $this->customerId = $this->customer->id ?? NULL;
        $this->bundleId = $bundle->id ?? NULL;
        //do we already have calculations for this customer and bundle? If so, load the cals first.
        if($this->customerId && $this->bundleId) {
            $this->loadByCustBundle($this->customerId, $this->bundleId);
        }
    }

    public function generateCalculations($cdr){
        //first, do we have config? If not, no point in continuing.
        if($this->customer->calculationConfig ?? FALSE) {
            //next we need to add all the information together,
            $this->generateTotals($cdr);
            $this->performCals();
            $this->getFinalCosts();
        }
        return $this;
    }

    protected function loadByCustBundle($custId, $bundleId){
        $calc = $this->operator->loadByCustBundle($custId, $bundleId);
        if(isset($calc['id'])) {
            parent::__call('load', [$calc['id']]);
        }
    }

    protected function performCals(){
        $this->setAllowables();
        //shorten things;
        $config = $this->customer->calculationConfig;
        $this->SubscriptionCharge = $this->totals['totalSims'] * $config->SIMsBillableRate;
        $this->DataVolume = $this->totals['dataVolume'];
        $this->DataVolumeOverage = ($this->totals['dataVolume'] <= $config->allowableData) ? 0 : $this->calcOverage('data');
        $this->SMSVolume = $this->totals['smsVolume'];
        $this->SMSMOVolume = $this->totals['smsMOVolume'];
        $this->SMSMOVolumeOverage = ($this->totals['smsMOVolume'] <= $config->allowableSMSMO) ? 0 : $this->calcOverage('SMSMO');
        $this->SMSMTVolume = $this->totals['smsMTVolume'];
        $this->SMSMTVolumeOverage = ($this->totals['smsMTVolume'] <= $config->allowableSMSMT) ? 0 : $this->calcOverage('SMSMT');
        $this->VoiceVolume = $this->totals['voiceVolume'];
        $this->VoiceMOVolume = $this->totals['voiceMOVolume'];
        $this->VoiceMOVolumeOverage = ($this->totals['voiceMOVolume'] <= $config->allowableMins) ? 0 : $this->calcOverage('voiceMO');
        $this->VoiceMTVolume = $this->totals['voiceMTVolume'];

        //set extra info
        $this->totalSims = $this->totals['totalSims'] ?? $this->totals['includedSims'];
        $this->activeSims = $this->totals['activeSims'];
        $this->billedFor = $this->customer->calculationConfig->ActiveOnly ? 'Active' : 'All';
        $this->subCharge = $this->customer->calculationConfig->SIMsBillableRate;
        //Voice MT isn't billed?
    }

    protected function setAllowables(){
        $totalSims = $this->customer->calculationConfig->ActiveOnly ? $this->totals['includedSims'] : $this->customer->calculationConfig->QuantityOfSims;
        $this->customer->calculationConfig->allowableData = $totalSims * $this->customer->calculationConfig->DataPerMonth;
        $this->customer->calculationConfig->allowableSMSMO = $totalSims * $this->customer->calculationConfig->TotalOutboundSMSPerMonth;
        $this->customer->calculationConfig->allowableSMSMT = $totalSims * $this->customer->calculationConfig->TotalInboundSMSPerMonth;
        $this->customer->calculationConfig->allowableMins = $totalSims * $this->customer->calculationConfig->TotalVoiceMinutesPerMonth;
        $this->customer->calculationConfig->billableData = $totalSims * $this->customer->calculationConfig->SIMsBillableRate;
        $this->totals['totalSims'] = $totalSims;
    }

    protected  function generateTotals($cdr){
        if(!empty($cdr)) {
            $i = 0;
            $a = 0;
            foreach ($cdr as $row) {
                //only count active sims.
                if($this->customer->calculationConfig->ActiveOnly && ($row['subscriberstatus'] ?? FALSE)){
                    if($row['subscriberstatus'] !== 'Active'){
                        $this->totals['skippedSims']++;
                        continue;
                    }
                }
                if($row['subscriberstatus'] === 'Active'){
                    ++$a;
                }
                $this->totals['subCharge'] = ($this->totals['subCharge'] ?? 0) + str_replace(',', '', $row['subscriptioncharge']);
                $this->totals['fixedPoolCharge'] = ($this->totals['fixedPoolCharge'] ?? 0) + str_replace(',', '',$row['fixedpoolcharge']);
                $this->totals['dataVolume'] = ($this->totals['dataVolume'] ?? 0) + str_replace(',', '',$row['datavolume(mb)']);
                $this->totals['smsVolume'] = ($this->totals['smsVolume'] ?? 0) + str_replace(',', '',$row['smsvolume(msg)']);
                $this->totals['smsMOVolume'] = ($this->totals['smsMOVolume'] ?? 0) + str_replace(',', '',$row['smsmovolume(msg)']);
                $this->totals['smsMTVolume'] = ($this->totals['smsMTVolume'] ?? 0) + str_replace(',', '',$row['smsmtvolume(msg)']);
                $this->totals['voiceVolume'] = ($this->totals['voiceVolume'] ?? 0) + (strtolower($row['voicevolume(m:ss)']) != 'combined' ? str_replace([':', ','], ['.', ''], $row['voicevolume(m:ss)']) : 0);
                $this->totals['voiceMOVolume'] = ($this->totals['voiceMOVolume'] ?? 0) + (strtolower($row['voicevolume(m:ss)']) != 'combined' ? str_replace([':', ','], ['.', ''], $row['voicemovolume(m:ss)']) : 0);
                $this->totals['voiceMTVolume'] = ($this->totals['voiceMTVolume'] ?? 0) + (strtolower($row['voicevolume(m:ss)']) != 'combined' ? str_replace([':', ','], ['.', ''], $row['voicemtvolume(m:ss)']) : 0);
                $this->totals['includedSims'] = ++$i;
            }
            $this->totals['activeSims'] = $a;
        }
    }

    protected function calcOverage($key){
        $config = $this->customer->calculationConfig;
        switch ($key){
            case 'data':
                return ($this->DataVolume - $config->allowableData) * $this->customer->calculationConfig->OverageDataRate;
            case 'SMSMO':
                return ($this->SMSMOVolume - $config->allowableSMSMO) * $this->customer->calculationConfig->OverageSMSMORate;
            case 'SMSMT':
                return ($this->SMSMTVolume - $config->allowableSMSMO) * $this->customer->calculationConfig->OverageSMSMTRate;
            case 'voiceMO':
                return ($this->VoiceMOVolume - $config->allowableMins) * $this->customer->calculationConfig->OverageVoiceRate;
            case 'voiceMT':
                return ($this->VoiceMTVolume - $config->allowableMins) * $this->customer->calculationConfig->OverageVoiceRate;
        }
        return 0;
    }

    protected function getFinalCosts(){
        $this->TotalCharge = $this->SubscriptionCharge
            + $this->DataVolumeOverage
            + $this->SMSMOVolumeOverage
            + $this->SMSMTVolumeOverage
            + $this->VoiceMOVolumeOverage;

    }

    /**
     * Allow us to store with base entity data, prevents the need o call a method while passing the result of another method to the operator
     */
    public function getCalcsByCustomerId(){
        $this->operator->getCalcsByCustomerId($this->data);
        return $this;
    }
}