<?php

namespace apexl\Io\modules\bundleBuilder\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\bundleBuilder\entities\operators\bundleConfigurationOperator;
use apexl\Io\modules\component\entities\operators\componentOperator;

class bundleConfigurationEntity extends Entity{

    public $allowableData;
    public $allowableSMSMO;
    public $allowableSMSMT;

    public function __construct()
    {
        parent::__construct('bundleBuilderConfiguration');
        $this->setOperator(new bundleConfigurationOperator('bundleBuilderConfiguration'));
    }

    /**
     * @param $customer
     */
    public function loadByCustomer($customer){
        //first we need to attempt to load any customer config
        parent::__call('loadByCustomer', [$customer]);
        //next, check if we loaded the whole global profile or not, if we did, just leave it at that.
        //if not, we need to check the customer config and override any blank values with the globals
        if($this->id !== 1){
            //get the global config
            $global = new bundleConfigurationEntity();
            $global->load(1);

            //override anything that's NULL.
            $this->DataPerMonth = $this->DataPerMonth ?? $global->DataPerMonth;
            $this->TotalOutboundSMSPerMonth = $this->TotalOutboundSMSPerMonth ?? $global->TotalOutboundSMSPerMonth;
            $this->TotalInboundSMSPerMonth = $this->TotalInboundSMSPerMonth ?? $global->TotalInboundSMSPerMonth;
            $this->TotalVoiceMinutesPerMonth = $this->TotalVoiceMinutesPerMonth ?? $global->TotalVoiceMinutesPerMonth;
            $this->SIMsBillableRate = $this->SIMsBillableRate ?? $global->SIMsBillableRate;
            $this->OverageSMSMORate = $this->OverageSMSMORate ?? $global->OverageSMSMORate;
            $this->OverageSMSMTRate = $this->OverageSMSMTRate ?? $global->OverageSMSMTRate;
            $this->OverageVoiceRate = $this->OverageVoiceRate ?? $global->OverageVoiceRate;
        }
    }

    public function load($id){
        parent::__call('load', [$id]);
        if(empty($this->data)){
            //load global config
            parent::__call('load', [1]);
        }
    }
}