<?php

namespace apexl\Io\modules\bundleBuilder\entities;

use apexl\EasyCSV;
use apexl\Io\includes\Entity;
use apexl\Io\includes\Utils;
use apexl\Io\modules\file\entities\fileEntity;

class bundleEntity extends Entity{

    public function __construct()
    {
        parent::__construct('bundleBuilderBundles');
    }

    /**
     * Function to process the bundles attached CDR file.
     * @throws \Exception
     */
    public function processBundle(){
        //We need to split the feed by customer
        $fileEntity = new fileEntity();
        $fileEntity->load($this->file);
        //check the file mime, if its not a csv, assume its an excel file and convert it.
        if(Utils::mime2ext($fileEntity->mime) != 'csv'){
            $sheets = $fileEntity->fileService::spreadsheet2CSV($fileEntity);
            //we need to take the first file only, since we only support one sheet for this. Unlink the old file and
            // replace the bundle with the new one.
            $file = array_shift($sheets);
            $this->file = $file->id;
            $this->store();

            //delete the old file
            $fileEntity->delete();

            //set the file entity to the new file.
            $fileEntity = $file;

            //cleanup any extra sheets
            foreach($sheets as $sheet){
                $sheet->delete();
            }
        }

        //start processing the csv file.
        $eaCSV = new EasyCSV();
        $eaCSV->loadFromFile($fileEntity->getLocalPath());
        //now we need to loop over these records and split them into customer records.
        $customers = $this->splitBundleByCustomer($eaCSV->csvArray);
        $customerTotal = count($customers);
        $processedCustomers = 0;
        //next we need to check if we have each customer. If we dont, we need to create them, if we do, we need to load them.
        foreach($customers as $customerName => $customerData){
            $jCustomer = new jasperCustomerEntity();
            $jCustomer->loadByCustomerName($customerName);
            if(!isset($jCustomer->id)){
                //no id? then this is a new record.
                $jCustomer->CustomerName = $customerName;
                $jCustomer->store();
            } else {
                $bundleCalcs = new bundleCalculationsEntity($jCustomer, $this);
                //now we need to perform the calculations for this customer, if it was not a new creation.
                //New creations will need configuration, so skip those by using if/else.
                $bundleCalcs->generateCalculations($customerData);
                $bundleCalcs->store();
                ++$processedCustomers;
            }

        }

        $this->customerCount = $customerTotal;
        $this->customersProcessed = $processedCustomers;

        $this->store();
    }

    protected function splitBundleByCustomer(array $csv){
        $customers = [];
        $rows = count($csv); //count the rows, allows usage of for loops - much faster than foreach in this context.
        for ($i = 0; $i < $rows; ++$i) {
            $cName = $csv[$i]['customer'] ?? FALSE;
            if($cName){
                $customers[$cName][] = $csv[$i];
            }
        }
        return $customers;
    }
}