<?php

namespace apexl\Io\modules\bundleBuilder\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\bundleBuilder\entities\operators\jasperCustomerOperator;

class jasperCustomerEntity extends Entity{

    public $calculationConfig;

    public function __construct()
    {
        parent::__construct('bundleBuilderCustomers');
        $this->setOperator(new jasperCustomerOperator('bundleBuilderCustomers'));
    }

    /**
     * Allow us to store with base entity data, prevents the need o call a method while passing the result of another method to the operator
     */
    public function store(){
        $this->operator->store($this->data);
        return $this;
    }

    public function loadByCustomerName($name){
        parent::__call('loadByCustomerName', [$name]);
        $this->loadCustomerConfig();
    }

    public function load($id){
        parent::__call('load', [$id]);
        //next we need to load the calculations for this specific customer, so load the config.
        $this->loadCustomerConfig();
    }

    public function getCalculations(){
        $calculationsEntity = new bundleCalculationsEntity($this);
        $cals = $calculationsEntity->getCalcsByCustomerId();
    }
    protected function loadCustomerConfig(){
        $this->calculationConfig = new bundleConfigurationEntity();
        $this->calculationConfig->loadByCustomer($this->id);
        //we need to make sure each customer can save their own config.
        if($this->calculationConfig->id == 1){
            unset($this->calculationConfig->id);
        }
    }
}