<?php

namespace apexl\Io\modules\bundleBuilder\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class calculationsOperator extends entityDatabaseOperator{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function loadByBundle($bundleId){
        $entity = $this->vault->select($this->dbTable)->fields()->where('bundleId', $bundleId)->execute()->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function loadByCustBundle($custId, $bundleId){
        return $this->vault->select($this->dbTable)->fields()->where('customerId', $custId)->where('bundleId', $bundleId)->execute()->fetchAssoc();
    }

    public function getCalcsByCustomerId($custId){
        return $this->vault->select($this->dbTable)->fields()->where('customerId', $custId)->execute()->fetchAll();
    }
}