<?php
namespace apexl\Io\modules\bundleBuilderDisplay;

use apexl\Io\includes\Module;
use apexl\Io\modules\bundleBuilderDisplay\controllers\bundleBuilderController;
use apexl\Io\modules\bundleBuilderDisplay\controllers\bundleMenuController;
use apexl\Io\modules\bundleBuilderDisplay\controllers\formsController;
use apexl\Io\modules\menu\services\Menu;

class bundleBuilderDisplayModule extends Module {
    protected $menu;

    public function __construct()
    {
        parent::__construct();
        $this->menu = Menu::getInstance();
        $this->registerMenuCallbacks();
    }

    public function routes() {
        $this->bundleBuilderRoutes();
    }

    protected function bundleBuilderRoutes(){
        //display routes
        //pages
        $this->route->get('/bundleBuilder', bundleBuilderController::class.':builderHome', 'BundleBuilder')->addToMenu('Bundle Builder', 'boxes-alt');
        $this->route->get('/bundleBuilder/overview', bundleBuilderController::class.':builderHome', 'BundleBuilder')->addToMenu('Overview', 'galaxy', '/bundleBuilder');
        $this->route->get('/bundleBuilder/bundles/{id}/view', bundleBuilderController::class.':builderBundleView', 'BundleBuilder');
        $this->route->get('/bundleBuilder/bundles', bundleBuilderController::class.':builderBundleList', 'BundleBuilder')->addToMenu('CDRs', 'boxes-alt', '/bundleBuilder');

        $this->route->get('/bundleBuilder/customer/{id}/edit', bundleBuilderController::class.':builderCustomerAddEdit', 'BundleBuilder');
        $this->route->get('/bundleBuilder/customer/{id}/view', bundleBuilderController::class.':builderCustomerSingle', 'BundleBuilder');
        $this->route->get('/bundleBuilder/customer/create', bundleBuilderController::class.':builderCustomerAddEdit', 'BundleBuilder')->addToMenu('Create Customer', 'layer-plus', '/bundleBuilder');
        $this->route->get('/bundleBuilder/customer', bundleBuilderController::class.':builderCustomerList', 'BundleBuilder')->addToMenu('Customers', 'layer', '/bundleBuilder');

        $this->route->get('/bundleBuilder/global-configuration', bundleBuilderController::class.':globalConfigEdit', 'BundleBuilder')->addToMenu('Global Configuration', 'cogs', '/bundleBuilder');

        //forms
        $this->route->get('/forms/bb/upload-cdr', formsController::class.':uploadCdr', 'BundleBuilder');
        $this->route->get('/forms/bb/customer/configuration[/{id}]', formsController::class.':addEditConfiguration', 'BundleBuilder');
        $this->route->get('/forms/bb/customer[/{id}]', formsController::class.':addEditCustomer', 'BundleBuilder');
    }

    public function install(){

    }

    protected function registerMenuCallbacks(){
        $this->menu->registerCallback('bundleBuilder/customer/{id}/view', [bundleMenuController::class, 'customerMenu']);
        $this->menu->registerCallback('bundleBuilder/customer/{id}/edit', [bundleMenuController::class, 'customerMenuEdit']);
    }
}