<?php

namespace apexl\Io\modules\bundleBuilderDisplay\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\bundleBuilder\entities\bundleConfigurationEntity;
use apexl\Io\modules\bundleBuilder\entities\bundleEntity;
use apexl\Io\modules\bundleBuilder\entities\jasperCustomerEntity;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\pages\genericPage;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class bundleBuilderController {

    protected $menu;
    protected $currentUser;
    protected $genericPage;

    public function __construct(Menu $menu, currentUser $currentUser){
        $this->menu = $menu;
        $this->currentUser = $currentUser::getCurrentUser();
        $this->genericPage = new genericPage($this->menu, $this->currentUser);
    }

    public function builderHome(Request $request, Response $response){
        //upload CDR file (tile)
        $uploadTile = genericComponents::formTile("uploadCdr", '/forms/bb/upload-cdr', 'col-md-12');

        $bundles = genericComponents::linkTile('/bundleBuilder/bundles', 'boxes-alt', 'CDRs');
        $bundles->classes = 'col-md-2';
        $customerLinkTile = genericComponents::linkTile('/bundleBuilder/customer', 'layer-group', 'Customers');
        $customerLinkTile->classes = 'col-md-2';
        $globalConfigLinkTile = genericComponents::linkTile('/bundleBuilder/global-configuration', 'cogs', 'Global Configuration');
        $globalConfigLinkTile->classes = 'col-md-2';

        //Wrap the button row
        $buttonWrapper = genericComponents::contentWrapper([$bundles, $customerLinkTile, $globalConfigLinkTile]);
        //latest complete bundles (table)
        return System::asJson($response, $this->genericPage->setPageTitle('CDR Dashboard')->wrapper([$uploadTile, $buttonWrapper]), 200);
    }

    public function builderBundleList(Request $request, Response $response){
        $bundles = genericComponents::dataTable('/api/bb/bundle', '', TRUE, FALSE, FALSE, '/bundleBuilder/bundles', 'BundleBuilder');
        $processButton = genericComponents::tableButton('/api/bb/process-cdr', 'lightbulb-exclamation', 'Process', 'btn-warning');
        $processButton->verb = 'post'; //this is a post route, so update it.
        $bundles->addComponent($processButton);
        return System::asJson($response, $this->genericPage->setPageTitle('CDR List')->wrapper([$bundles], 'withBackground'), 200);
    }

    public function builderCustomerSingle(Request $request, Response $response, $args){
        if($id = $args['id'] ?? FALSE) {
            $customer = new jasperCustomerEntity();
            $customer->load($id);
            if(!isset($customer->id)){
                return System::asJson($response, System::output(['type' => 'error', 'content' => 'Customer not found']), 404);
            }
            $customerLinkTile = genericComponents::linkTile('/bundleBuilder/customer/' . $args['id'] . '/edit', 'edit', 'Edit');
            $customerLinkTile->classes = 'col-md-2';
            $buttonWrapper = genericComponents::contentWrapper([$customerLinkTile]);
            $calculations = genericComponents::dataTable('/api/bb/calculation?customerId=' . $args['id'], 'withBackground');
            $calculations->addProperty("colspans", [0 => 3]);
            $calculations->addProperty("hideIdColumn", TRUE);
            return System::asJson($response, $this->genericPage->setPageTitle($customer->CustomerName)->wrapper([$buttonWrapper, $calculations]));
        } else {
            return System::asJson($response, System::output(['type' => 'error', 'content' => 'Customer not found']), 404);
        }
    }

    public function builderCustomerList(Request $request, Response $response){
        $customers = genericComponents::dataTable('/api/bb/customer', '', TRUE, 'BundleBuilder', 'BundleBuilder', '/bundleBuilder/customer', 'BundleBuilder');
        return System::asJson($response, $this->genericPage->setPageTitle('Customer List')->wrapper([$customers], 'withBackground'));
    }

    public function builderCustomerAddEdit(Request $request, Response $response, $args){
        $customerArg = isset($args['id']) ? '/'.$args['id'] : '';
        $configArg = '/1';
        $title = 'Create Customer';
        $configuration = genericComponents::formTile("configurationForm", '/forms/bb/customer/configuration'.$configArg);
        if(isset($args['id'])){
            $customerEntity = new jasperCustomerEntity();
            $customerEntity->load($args['id']);
            $configuration = new bundleConfigurationEntity();
            $configuration->loadByCustomer($args['id']);
            $configArg = '/'.($configuration->id ?? 1);
            $title = 'Edit '.$customerEntity->CustomerName;
            $configuration = genericComponents::formTile("configurationForm", '/forms/bb/customer/configuration'.$configArg.'?customerId='.$args['id'] );
        }
        $customer = genericComponents::formTile("customerForm", '/forms/bb/customer'.$customerArg);
        $customer->addProperty("title", "Customer Fields");

        $configuration->addProperty("title", "Customer Configuration");
        return System::asJson($response, $this->genericPage->setPageTitle($title)->wrapper([$customer, $configuration], 'withBackground'), 200);
    }

    public function builderBundleView(Request $request, Response $response, $args){
        if($id = $args['id'] ?? FALSE){
            $bundle = new bundleEntity();
            $bundle->load($id);

            $calculations = genericComponents::dataTable('/api/bb/calculation?bundleId=' . $args['id'], 'withBackground', TRUE, FALSE, FALSE, '/bundleBuilder/customer');
            $calculations->addProperty("hideIdColumn", TRUE);
            $calculations->addProperty("colspans", [0 => 3]);
            return System::asJson($response, $this->genericPage->setPageTitle('CDR ('.date('d/m/Y H:i:s', $bundle->createdDate).')')->wrapper([$calculations], 'withBackground'));
        } else {
            return System::asJson($response, System::output(['type' => 'error', 'content' => 'Bundle not found']), 404);
        }
    }

    public function globalConfigEdit(Request $request, Response $response){
        $configuration = genericComponents::formTile("configurationForm", '/forms/bb/customer/configuration/1');
        return System::asJson($response, $this->genericPage->wrapper([$configuration], 'withBackground'), 200);
    }
}