<?php
namespace apexl\Io\modules\bundleBuilderDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\modules\bundleBuilder\entities\jasperCustomerEntity;
use apexl\Io\modules\menu\entities\menuEntity;

class bundleMenuController extends Controller {

    protected function customerMenuItem($id, $event = FALSE){
        $menu = new menuEntity();
        $customer = new jasperCustomerEntity();
        $customer->load($id);
        if(isset($customer->id)) {
            return $menu->createMenuLinkItem((object)[
                'title' => ($event ? ucfirst($event).' ' : ''). $customer->CustomerName,
                'href' => '/bundleBuilder/customer/'.$customer->id.($event ? '/'.$event : '')
            ], FALSE);
        }
        return FALSE;
    }

    public function customerMenu($id){
        return bundleMenuController::customerMenuItem($id);
    }

    public function customerMenuEdit($id){
        return bundleMenuController::customerMenuItem($id, 'edit');
    }
}