<?php

namespace apexl\Io\modules\bundleBuilderDisplay\controllers;

use apexl\Io\includes\System;
use apexl\Io\modules\bundleBuilder\entities\bundleConfigurationEntity;
use apexl\Io\modules\bundleBuilder\entities\jasperCustomerEntity;
use apexl\Io\modules\display\components\genericForms;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class formsController{

    protected $currentUser;

    public function __construct(currentUser $currentUser){
        $this->currentUser = $currentUser::getCurrentUser();
    }

    public function uploadCdr(Request $request, Response $response){
        $fileForm = genericForms::fileUploadForm('api/bb/files/upload-cdr');
        $fileForm->setActionUrl('api/bb/files/upload-cdr');
        $fileForm->removeSubmitButton();
        return System::asJson($response, $fileForm->getBuiltFormArray());
    }

    public function addEditCustomer(Request $request, Response $response, $args){
        $form = genericForms::entityForm('api/bb/customer', (new jasperCustomerEntity()), $args);
        return System::asJson($response, $form->getBuiltFormArray());
    }

    public function addEditConfiguration(Request $request, Response $response, $args){
        $params = $request->getQueryParams();
        $form = genericForms::entityForm('api/bb/customer/configuration', (new bundleConfigurationEntity()), $args);
        $customerField = (new inputField("Customer"))->setLabel('customerId')->setValue(($params['customerId'] ?? 0))->setInputType('hidden');
        $form->addField($customerField);
        return System::asJson($response, $form->getBuiltFormArray(), 200);
    }
}