<?php

namespace apexl\Io\modules\company;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\company\callbacks\accessControl;
use apexl\Io\modules\company\callbacks\userPostSave;
use apexl\Io\modules\company\controllers\companyController;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\Permissions;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class companyModule extends userManagedApiModule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {
        $this->addProtectedEntityRoutes((new companyEntity()), [
            'get' => [companyController::class.':get', 'ViewCoreCompanies'],
            'put' => [companyController::class.':put', 'UpdateCoreCompany'],
            'post' => [companyController::class.':post', 'CreateCoreCompany'],
            'delete' => [companyController::class.':delete', 'DeleteCoreCompany'],
        ]);
    }

    public function schema()
    {
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    public function install()
    {
        //create a default Apexl Studios Ltd company on install so that we don't have AC issues.
        $company = new companyEntity();
        $company->CompanyName = 'Apexl Studios Ltd';
        $company->CompanyContactEmail = 'admin@apexlstudios.com';
        $company->store();

        //next, load user 1 and assign the new company.
        $company->storeCompanyUser($company->id, 1);
    }

    public function registerCallbacks()
    {
        Hook::registerCallback('entityLoadMultipleQuery', accessControl::class.':entityLoadQuery');
        Hook::registerCallback('entityLoadMultipleFields', accessControl::class.':entityLoadFields');
        Hook::registerCallback('entityLoadFields', accessControl::class.':entityLoadFields');
        Hook::registerCallback('entityLoadQuery', accessControl::class.':entityLoadQuery');
        Hook::registerCallback('userPostSave', userPostSave::class.':alter');
    }

    public function registerPermissions(Permissions $permissions)
    {
        $permissions->registerPermission('CreateCoreCompany', 'Create Companies', 'Companies');
        $permissions->registerPermission('UpdateCoreCompany', 'Update Companies', 'Companies');
        $permissions->registerPermission('ViewCoreCompanies', 'View Companies', 'Companies');
        $permissions->registerPermission('DeleteCoreCompany', 'Delete Companies', 'Companies');
        $permissions->registerPermission('AssignCompanyToUsers', 'Manage Company Membership', 'Entity Access');

        $permissions->registerPermission('AccessGlobalEntities', 'Access All Entities', 'Entity Access');
        $permissions->registerPermission('AccessCompanyUsers', 'Access Own Company Users', 'Entity Access');
        $permissions->registerPermission('AccessCompanyEntities', 'Access entities owned by user company', 'Entity Access');
        $permissions->registerPermission('AccessOwnEntities', 'Access own entities', 'Entity Access');
    }
}
