<?php

namespace apexl\Io\modules\company\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\display\includes\Forms;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class companyController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function createUpdateCompany(Request $request, Response $response, $args)
    {
        $form = Forms::entityForm(new companyEntity(), $args);
        $this->output::addResponse($request, $form->getBuiltFormArray());
        return System::asJson($response);
    }

    /**
     * @param $entity
     * @param $params
     * @param $validFields
     * @return array
     */
    protected function buildFilterConditions($entity, $params, $validFields = []): array
    {
        $filters = parent::buildFilterConditions($entity, $params, $validFields);
        //override some of the filters to add LIKE queries.

        if (isset($filters['CompanyContactEmail'])) {
            $filters['CompanyContactEmail'][1] = '%' . $filters['CompanyContactEmail'][1] . '%';
            $filters['CompanyContactEmail'][2] = 'LIKE';
        }

        if (isset($filters['CompanyName'])) {
            $filters['CompanyName'][1] = '%' . $filters['CompanyName'][1] . '%';
            $filters['CompanyName'][2] = 'LIKE';
        }

        return $filters;
    }
}
