<?php

namespace apexl\Io\modules\company\callbacks;

use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;

class accessControl
{
    //We want to store all known company user IDs on the first pass for easy IN queries.
    //@todo make this better?
    protected static $companyUsers;

    public static function getCompanyUsers()
    {
        $currentUser = currentUser::getCurrentUser();
        $company = new companyEntity();
        $users = $company->getAllCompanyUsers($currentUser->CompanyId);
        if (!empty($users)) {
            foreach ($users as $user) {
                self::$companyUsers[] = $user->UserId;
            }
        }
    }

    public static function entityLoadQuery($query, $table)
    {
        $query = clone $query;
        $currentUser = currentUser::getCurrentUser();
        switch($table) {
            case 'users':
                //Allow anon user to left join, so we don't break login.
                if ($currentUser->isAllowed('AccessGlobalEntities') || $currentUser->id == 0) {
                    $query->leftJoin('company_users', 'UserId', 'users.id');
                    $query->leftJoin('company', 'company.id', 'company_users.CompanyId');
                } else {
                    $query->Join('company_users', 'UserId', 'users.id');
                    $query->Join('company', 'company.id', 'company_users.CompanyId');
                }
                break;
            case 'subscription':
                //Allow anon user to left join, so we don't break login.
                if ($currentUser->isAllowed('AccessGlobalEntities') || $currentUser->id == 0) {
                    $query->leftJoin('company_users', 'subscription.user_id', 'company_users.userId');
                    $query->leftJoin('company', 'company.id', 'company_users.CompanyId');
                } else {
                    $query->Join('company_users', 'subscription.user_id', 'company_users.userId');
                    $query->Join('company', 'company.id', 'company_users.CompanyId');
                }
                break;
            case 'sim_order':
                //Allow anon user to left join, so we don't break login.
                if ($currentUser->isAllowed('AccessGlobalEntities') || $currentUser->id == 0) {
                    $query->leftJoin('company_users', 'sim_order.user_id', 'company_users.userId');
                    $query->leftJoin('company', 'company.id', 'company_users.CompanyId');
                } else {
                    $query->Join('company_users', 'sim_order.user_id', 'company_users.userId');
                    $query->Join('company', 'company.id', 'company_users.CompanyId');
                }
                break;
        }
        return $query;
    }


    /**
     * @impliments entityAccess hook
     * @param $entity
     * @param $table
     * @return array|mixed
     */
    public static function entityAccessCallback($entity, $table)
    {
        if (!empty($entity) && $table === 'users') {
            //first, allow us to load ourselves, or allow managers to load the record.
            $currentUser = currentUser::getCurrentUser();
            if ($currentUser->id == $entity['id'] || $currentUser->isAllowed('AccessGlobalEntities')) {
                return $entity;
            }
            if ($currentUser->isAllowed('AccessCompanyUsers') && $entity['CompanyId'] == $currentUser->CompanyId) {
                return $entity;
            } else {
                $entity = [];
            }
        }
        return $entity;
    }

    public static function entityLoadFields($fields, $table)
    {
        if ($table === 'users') {
            $fields['company_users'] = ['id as company_user_id', 'UserId', 'CompanyId'];
            $fields['company'] = ['id as company_id', 'CompanyContactEmail', 'CompanyName'];
            return $fields;
        }

        return $fields;
    }

    public static function entityLoadMultipleFields($fields, $table)
    {
        if ($table === 'users') {
            $currentUser = currentUser::getCurrentUser();
            if ($currentUser->isAllowed('AccessGlobalEntities')) {
                //nothing to do here, we can access everything.
                return $fields;
            } else {
                $fields['company_users'] = ['id as company_user_id', 'UserId', 'CompanyId'];
                $fields['company'] = ['id as company_id', 'CompanyContactEmail', 'CompanyName'];
            }
        }

        return $fields;
    }
}
