<?php

namespace apexl\Io\modules\companyDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class formsController extends Controller
{
    protected $currentUser;

    public function __construct()
    {
        parent::__construct();
    }

    public function createUpdateForm(Request $request, Response $response, $args)
    {
        $form = Forms::entityForm(new companyEntity(), $args);
        $this->output::addResponse($request, $form->getBuiltFormArray());
        return System::asJson($response);
    }

    public function companyFilter(Request $request, Response $response)
    {
        $form = new formEntity();
        $form->setId('companyFilter');
        $form->addClass('filter-form');
        $form->setMethod('post');
        $form->setActionUrl('#');
        $form->setSubmitText('Search');
        $form->includeClearButton()->setClearButtonText('Reset filters');

        $form->addFieldToGroup((new inputField('CompanyContactEmail'))->setLabel('Company Contact Email')->setPlaceholder('Company Contact Email'), 'company_filters');
        $form->addFieldToGroup((new inputField('CompanyName'))->setLabel('Company Name')->setPlaceholder('Company Name'), 'company_filters');

        $this->output::addResponse($request, $form->getBuiltFormArray());
        return System::asJson($response);
    }
}
