<?php

namespace apexl\Io\modules\companyDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\display\components\ButtonBar;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\user\entities\userEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class companyController extends Controller
{
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
    }

    public function view(Request $request, Response $response, $args)
    {
        if ($id = $args['id'] ?? false) {
            $company = new companyEntity();
            $company->load($id);
            if ($company->id ?? false) {
                $viewTable = new DisplayTable();
                $viewTable->addData('Primary Contact Email', $company->CompanyContactEmail);
                $viewTable->addData('Company Number', $company->CompanyNumber);
                $viewTable->addData('VAT Number', $company->VATNumber);

                $this->render::setPageTitle($company->CompanyName);
                $this->output::addResponse($request, $this->render::build([genericComponents::dashboardBlockWrapper([$viewTable])]));
                return System::asJson($response);
            }
        }
        return $this->throw404($response);
    }

    public function list(Request $request, Response $response)
    {
        $buttonBar = new ButtonBar();
        $buttonBar->setEntity((new companyEntity()), 'List');

        $filterForm = (new CardEntityFilteredDisplayTable(new companyEntity(), [], true, 'dropmenu'))
            ->addFilterForm('companies.form.filters.companyListFilter', null, 5, true, "Filter Companies")
            ->addProperty('refreshButton', '<i class="fa-light fa-arrows-rotate"></i>')
            ->addTitle('Companies')
        ;
        //render
        $this->render::setPageTitle('Companies List');
        $this->output::addResponse($request, $this->render::build([$buttonBar, $filterForm]));
        return System::asJson($response);
    }

    public function create(Request $request, Response $response, $args)
    {
        $title = 'Create new company';
        if ($id = $args['id'] ?? false) {
            $company = new companyEntity();
            $company->load($args['id']);
            $title = 'Update ' . $company->CompanyName;
        }

        $form = (new FormComponent())->setID('companyCreate')->src(Routes::getRoutePattern('companies.form.createUpdate', $args));
        $this->render::setPageTitle($title);
        $this->output::addResponse($request, $this->render::build([genericComponents::dashboardBlockWrapper([$form])]));
        return System::asJson($response);
    }

    public function createUpdateForm(Request $request, Response $response, $args)
    {
        $form = new formEntity();
        $company = new companyEntity();
        $form->setActionUrl(Routes::getRoutePattern($company->getEntityName().'.post'));

        //Company Name
        $name = (new inputField('CompanyName'))->setLabel("Company Name")->setPlaceholder('Enter company name')->isRequired()->addClass('col-md-6');
        $email = (new inputField('CompanyContactEmail'))->setLabel("Primary Contact Email")->setPlaceholder('Enter primary contact email address')->isRequired()->addClass('col-md-6');
        $companyNumber = (new inputField('CompanyNumber'))->setLabel("Company Number")->setPlaceholder('Enter Company Number')->addClass('col-md-6');
        $VATNumber = (new inputField('VATNumber'))->setLabel("VAT Number")->setPlaceholder('Enter VAT Number')->addClass('col-md-6');
        $active = (new checkboxField('Active'))->setLabel('Active?');

        if ($id = $args[$company->primaryKey] ?? false) {
            $form->setActionUrl(Routes::getRoutePattern($company->getEntityName().'.put', ['id' => $id]));
            $company->load($id);
            $name->setValue($company->CompanyName);
            $email->setValue($company->CompanyContactEmail);
            $companyNumber->setValue($company->CompanyNumber);
            $VATNumber->setValue($company->VATNumber);
            $active->setValue($company->Active);
        }

        $form->addFieldToGroup($name, 'basic_info')->addFieldGroupClasses('basic_info', 'row');
        $form->addFieldToGroup($email, 'basic_info')->addFieldGroupClasses('basic_info', 'row');
        $form->addFieldToGroup($companyNumber, 'registration_info')->addFieldGroupClasses('basic_info', 'row');
        $form->addFieldToGroup($VATNumber, 'registration_info')->addFieldGroupClasses('basic_info', 'row');
        $form->addField($active);

        return System::asJson($response, $form->getBuiltFormArray(), 200);
    }
}
