<?php

namespace apexl\Io\modules\company\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class companyOperator extends entityDatabaseOperator
{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getAllCompanyUsers($companyId)
    {
        return $this->vault->select('company_users')->fields()
            ->where('CompanyId', $companyId)
            ->execute()
            ->fetchAll();
    }

    public function loadByUser($userId)
    {
        $entity = $this->vault->select($this->dbTable)->fields()
            ->join('company_users', 'company.id', 'CompanyId')
            ->where('UserId', $userId)
            ->execute()
            ->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function loadByCompanyContactEmail($companyContactEmail)
    {
        $entity = $this->vault->select($this->dbTable)->fields()
            ->where('CompanyContactEmail', $companyContactEmail)
            ->execute()
            ->fetchAssoc();
        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function getCompanyUser($userId)
    {
        return $this->vault->select('company_users')->fields()
            ->where('UserId', $userId)
            ->execute()
            ->fetchAssoc();
    }

    public function deleteCompanyUser($id)
    {
        $this->vault->delete('company_users')->where('id', $id)->execute();
    }

    public function storeCompanyUser($companyId, $userId)
    {
        //check if we have an existing record.
        $record = $this->getCompanyUser($userId);
        if (!empty($record) && isset($record['id'])) {
            //update!
            $this->vault->update('company_users')->fields(['CompanyId' => $companyId])->where('id', $record['id'])->execute();
        } else {
            //insert
            $this->vault->insert('company_users')->fields(['CompanyId' => $companyId, 'UserId' => $userId])->execute();
        }
    }

    public function fetchAllCompanyEmailAddresses()
    {
        $companies = [];
        $rows = $this->vault->select('company')->fields(['CompanyContactEmail','id'])
            ->execute()
            ->fetchAll();
        foreach ($rows as $row) {
            $companies[$row->id] = $row->CompanyContactEmail;
        }

        return $companies;
    }
}
