<?php

namespace apexl\Io\modules\companyDisplay;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\companyDisplay\callbacks\displayFormRender;
use apexl\Io\modules\companyDisplay\callbacks\redirects;
use apexl\Io\modules\companyDisplay\controllers\companyController;
use apexl\Io\modules\companyDisplay\controllers\formsController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\userDisplay\userDisplayModule;

class companyDisplayModule extends userDisplayModule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes(): void
    {
        $this->addProtectedEntityRoutes((new companyEntity()), [
            'all' => [companyController::class.':list', 'ViewCoreCompanies'],
            'get' => [companyController::class.':view', 'ViewCoreCompanies'],
            'put' => [companyController::class.':create', 'UpdateCoreCompany'],
            'post' => [companyController::class.':create', 'CreateCoreCompany'],
            'delete' => [Controller::class.':delete', 'DeleteCoreCompany'],
        ]);

        //forms
        $this->addProtectedFormRoute(
            'companies.form.createUpdate',
            'createUpdate[/{id}]',
            formsController::class.':createUpdateForm',
            'CreateCoreCompany'
        );
        $this->addProtectedFormRoute(
            'companies.form.filters.companyListFilter',
            'filters/companyFilter',
            formsController::class.':companyFilter',
            'CreateCoreCompany'
        );
    }

    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('companyEntity.display.all', [
            'title' => 'View All Companies',
            'parent' => 'user.admin',
            'icon' => 'layer-group',
        ], 'administration');

        $menu::addToMenu('companyEntity.display.post', [
            'title' => 'Create a Company',
            'parent' => 'user.admin',
            'icon' => 'layer-plus',
        ], 'administration');
    }

    public function registerCallbacks()
    {
        Hook::registerCallback('addResponse', redirects::class.':redirects');
        Hook::registerCallback('displayFormRender', displayFormRender::class.':alter');
    }
}
