<?php

declare(strict_types=1);

namespace apexl\Io\modules\company\entities;

use apexl\entityCore\enums\Casts;
use apexl\entityCore\traits\hasCasts;
use apexl\Io\includes\Entity;
use apexl\Io\modules\company\entities\operators\companyOperator;
use DateTimeImmutable;

/**
 * @property int $id
 * @property string $CompanyName
 * @property string $CompanyContactEmail
 * @property int $CompanyNumber
 * @property string $VATNumber
 * @property bool $Active
 * @property DateTimeImmutable $created
 * @property int $created_by
 * @property DateTimeImmutable $modified
 * @property int $modified_by
 *
 * @mixin companyOperator
 */
class companyEntity extends Entity
{
    use hasCasts;

    private const TABLE = 'company';

    public function __construct()
    {
        parent::__construct(self::TABLE);
        $this->setRequiredData(['CompanyName']);
        $this->setOperator(new companyOperator(self::TABLE));
    }

    public function casts(): array
    {
        return [
            'id' => Casts::INT,
            'CompanyNumber' => Casts::INT,
            'Active' => Casts::BOOL,
            'created' => Casts::DATETIME_STAMP,
            'modified' => Casts::DATETIME_STAMP,
        ];
    }
}
