<?php

declare(strict_types=1);

namespace apexl\Io\modules\company\hooks;

use apexl\Io\hooks\AbstractHook;

final readonly class AddCompanyFieldsToQuery extends AbstractHook
{
    protected static function hooks(): array
    {
        return [
            'entityLoadMultipleFields',
            'entityLoadFields',
        ];
    }

    public function __invoke(array $fields, string $table): array
    {
        if ($table === 'users') {
            $fields['company_users'] = ['id as company_user_id', 'UserId', 'CompanyId'];
            $fields['company'] = ['id as company_id', 'CompanyContactEmail'];

            return $fields;
        }

        return $fields;
    }
}
