<?php

namespace apexl\Io\modules\company\callbacks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\user\entities\userEntity;
use Psr\Http\Message\ServerRequestInterface;

final readonly class StoreCompanyOnUserStore extends AbstractHook
{
    static protected function hooks(): array
    {
        return [
            'userPostSave',
        ];
    }

    public function __invoke(userEntity $user, ServerRequestInterface $request): userEntity
    {
        $body = $request->getParsedBody();
        $companyEntity = new companyEntity();

        //We need to check the selected team (if any) and create or update the record accordingly.
        if ($body->company ?? false) {
            $companyEntity->storeCompanyUser($body->company, $user->id);
        } else {
            //no id? check for an existing company record and remove it if there is one.
            $exists = $companyEntity->getCompanyUser($user->id);

            if (isset($exists['id'])) {
                $companyEntity->deleteCompanyUser($exists['id']);
            }
        }

        return $user;
    }
}
