<?php

namespace apexl\Io\modules\company\callbacks;

use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\user\services\currentUser;

class accessControl
{
    //We want to store all known company user IDs on the first pass for easy IN queries.
    //@todo make this better?
    protected static $companyUsers;

    public static function getCompanyUsers()
    {
        $currentUser = currentUser::getCurrentUser();
        $company = new companyEntity();
        $users = $company->getAllCompanyUsers($currentUser->CompanyId);
        if (!empty($users)) {
            foreach ($users as $user) {
                self::$companyUsers[] = $user->UserId;
            }
        }
    }


    /**
     * @impliments entityAccess hook
     * @param $entity
     * @param $table
     * @return array|mixed
     */
    public static function entityAccessCallback($entity, $table)
    {
        if (!empty($entity) && $table === 'users') {
            //first, allow us to load ourselves, or allow managers to load the record.
            $currentUser = currentUser::getCurrentUser();
            if ($currentUser->id == $entity['id'] || $currentUser->isAllowed('AccessGlobalEntities')) {
                return $entity;
            }
            if ($currentUser->isAllowed('AccessCompanyUsers') && $entity['CompanyId'] == $currentUser->CompanyId) {
                return $entity;
            } else {
                $entity = [];
            }
        }

        return $entity;
    }


    public static function entityLoadMultipleFields($fields, $table)
    {
        if ($table === 'users') {
            $currentUser = currentUser::getCurrentUser();
            if ($currentUser->isAllowed('AccessGlobalEntities')) {
                //nothing to do here, we can access everything.
                return $fields;
            } else {
                $fields['company_users'] = ['id as company_user_id', 'UserId', 'CompanyId'];
                $fields['company'] = ['id as company_id', 'CompanyContactEmail'];
            }
        }

        return $fields;
    }
}
