<?php

declare(strict_types=1);

namespace apexl\Io\modules\company;

use apexl\Io\modules\company\controllers\companyController;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\company\hooks\AddCompanyFieldsToQuery;
use apexl\Io\modules\company\hooks\JoinCompanyTablesToQuery;
use apexl\Io\modules\company\hooks\StoreCompanyOnUserStore;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\interfaces\registersPermissions;
use apexl\Io\modules\user\services\Permissions;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;
use Exception;

/**
 * Base module file, provides required methods to register things like routes and middleware.
 * Class installModule
 * @package apexl\Io\modules\install
 */
class companyModule extends userManagedApiModule implements registersPermissions, HasHooksInterface
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes(): void
    {
        $this->addProtectedEntityRoutes((new companyEntity()), [
            'get' => [companyController::class.':get', 'ViewCoreCompanies'],
            'put' => [companyController::class.':put', 'UpdateCoreCompany'],
            'post' => [companyController::class.':post', 'CreateCoreCompany'],
            'delete' => [companyController::class.':delete', 'DeleteCoreCompany'],
        ]);
    }

    /**
     * @throws Exception
     */
    public function install(): void
    {
        //create a default Apexl Studios Ltd company on install so that we don't have AC issues.
        $company = new companyEntity();
        $company->CompanyName = 'Apexl Studios Ltd';
        $company->CompanyContactEmail = 'admin@apexlstudios.com';
        $company->store();

        //next, load user 1 and assign the new company.
        $company->storeCompanyUser($company->id, 1);
    }


    public function permissions(Permissions $permissions): void
    {
        $permissions->registerPermission('CreateCoreCompany', 'Create Companies', 'Companies');
        $permissions->registerPermission('UpdateCoreCompany', 'Update Companies', 'Companies');
        $permissions->registerPermission('ViewCoreCompanies', 'View Companies', 'Companies');
        $permissions->registerPermission('DeleteCoreCompany', 'Delete Companies', 'Companies');
        $permissions->registerPermission('AssignCompanyToUsers', 'Manage Company Membership', 'Entity Access');

        $permissions->registerPermission('AccessGlobalEntities', 'Access All Entities', 'Entity Access');
        $permissions->registerPermission('AccessCompanyUsers', 'Access Own Company Users', 'Entity Access');
        $permissions->registerPermission(
            'AccessCompanyEntities',
            'Access entities owned by user company',
            'Entity Access'
        );
        $permissions->registerPermission('AccessOwnEntities', 'Access own entities', 'Entity Access');
    }

    public function hooks(): array
    {
        return [
            JoinCompanyTablesToQuery::class,
            AddCompanyFieldsToQuery::class,
            StoreCompanyOnUserStore::class,
        ];
    }
}
