<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateCompanyTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('company')
            ->addColumn('CompanyName', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('CompanyContactEmail', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('CompanyNumber', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('VATNumber', AdapterInterface::PHINX_TYPE_STRING)
            ->addColumn('Active', AdapterInterface::PHINX_TYPE_BOOLEAN, [
                'default' => 1,
                'null' => false,
            ])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
            ])
            ->addColumn('created_by', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
            ])
            ->addColumn('modified', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
            ])
            ->addColumn('modified_by', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
            ])->create();
    }
}
