<?php

declare(strict_types=1);

namespace apexl\Io\modules\company\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\user\services\currentUser;

final readonly class JoinCompanyTablesToQuery extends AbstractHook
{
    public function __construct(private currentUser $currentUserFinder)
    {
    }

    protected static function hooks(): array
    {
        return [
            'entityLoadMultipleQuery',
            'entityLoadQuery',
        ];
    }

    public function __invoke($query, string $table)
    {
        $query = clone $query;
        $currentUser = $this->currentUserFinder->getCurrentUser();

        switch ($table) {
            case 'users':
                //Allow anon user to left join, so we don't break login.
                if ($currentUser->isAllowed('AccessGlobalEntities') || $currentUser->id == 0) {
                    $query->leftJoin('company_users', 'UserId', 'users.id');
                    $query->leftJoin('company', 'company.id', 'company_users.CompanyId');

                    return $query;
                }

                $query->Join('company_users', 'UserId', 'users.id');
                $query->Join('company', 'company.id', 'company_users.CompanyId');

                return $query;

            case 'subscription':
                //Allow anon user to left join, so we don't break login.
                if ($currentUser->isAllowed('AccessGlobalEntities') || $currentUser->id == 0) {
                    $query->leftJoin('company_users', 'user_id', 'userId');
                    $query->leftJoin('company', 'company.id', 'company_users.CompanyId');

                    return $query;
                }

                $query->Join('company_users', 'user_id', 'userId');
                $query->Join('company', 'company.id', 'company_users.CompanyId');

                return $query;
        }

        return $query;
    }
}
