<?php

declare(strict_types=1);

namespace apexl\Io\modules\companyDisplay\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\markupField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Exception;

final readonly class AddCompanyFieldsToUserForm extends AbstractHook
{
    static protected function hooks(): array
    {
        return ['displayFormRender'];
    }

    /**
     * @throws Exception
     */
    public function invoke(formEntity $form, userEntity $user, string $formName): formEntity
    {
        if ($formName === 'userEditForm') {
            //we need to add a team field to the form.
            $companySelectLabel = (new markupField('company_label', 'Company: '))
                ->addClass('user_form_tl col-md-2 bmd-form-group');

            // Note quotations here are deliberate to make sure we match serialised data contents, not keys.
            $currentUser = currentUser::getCurrentUser();

            if ($currentUser === null) {
                return $form;
            }

            $companyEntity = new companyEntity();
            if ($currentUser->isAllowed('AssignCompanyToUsers')) {
                $companies = $companyEntity->loadMultiple();
                $options = [];
                if ($companies !== []) {
                    foreach ($companies as $company) {
                        $options[$company->id] = $company->CompanyName;
                    }
                }
                $selectField = (new selectField('company', $options))->addClass('col-md-3');
            } else {
                $companyEntity->load($currentUser->CompanyId);
                $form->addField(
                    (new inputField('company', 'hidden'))
                        ->setValue($currentUser->CompanyId)
                );
                $selectField = (new markupField('company_markup', $companyEntity->CompanyName))
                    ->addClass('col-md-3 bmd-form-group');
            }
            //check for default selection
            if (isset($user->id) && isset($user->CompanyId)) {
                $selectField->setValue($user->CompanyId);
            }
            $form->addFieldToGroup($companySelectLabel, 'company_group');
            $form->addFieldToGroup($selectField, 'company_group');
        }

        return $form;
    }
}
