<?php

declare(strict_types=1);

namespace apexl\Io\modules\companyDisplay\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\includes\Routes;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;

final readonly class RedirectFollowingCompanyStore extends AbstractHook
{
    static protected function hooks(): array
    {
        return ['addResponse'];
    }

    public function __invoke(ResponseInterface $response, string $route, Output $output): void
    {
        switch ($route) {
            case 'companyEntity.put':
            case 'companyEntity.post':
                $output::addMetadata(
                    'companyEntity.post.redirect',
                    'redirect',
                    Routes::getRoutePattern('companyEntity.display.all')
                );
                break;
        }
    }
}
