<?php

namespace apexl\Io\modules\component\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\component\entities\operators\propertyOperator;
use apexl\Utils\Strings\Sanitize;

class propertyEntity extends Entity
{
    public function __construct()
    {
        parent::__construct('component_props');
        $this->setOperator(new propertyOperator('component_props', 'id'));
    }

    public function setName($name)
    {
        $this->data["name"] = $name;
        return $this;
    }

    public function setValue($value)
    {
        $this->data["value"] = $value;
        return $this;
    }

    public function setCID($id)
    {
        $this->data["cid"] = $id;
        return $this;
    }

    public function setClasses($classes)
    {
        $this->data["classes"] = Sanitize::htmlClassify($classes);
        return $this;
    }

    public function setMetadata($value)
    {
        if ($value) {
            $this->data["metadata"] = json_encode($value);
        }
        return $this;
    }
}
