<?php

namespace apexl\Io\modules\component\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\component\entities\operators\propertyOperator;
use apexl\Utils\Strings\Sanitize;

/**
 * @property int $id
 * @property int $cid
 * @property string $name
 * @property mixed $value
 * @property array|string|null $classes
 * @property mixed $metadata
 */
class propertyEntity extends Entity
{
    private const TABLE = 'component_props';

    public function __construct()
    {
        parent::__construct(self::TABLE);
        $this->setOperator(new propertyOperator(self::TABLE));
    }

    public static function factory(
        string $name,
        mixed $value,
        array|string|null $classes = null,
        mixed $metaData = null
    ): propertyEntity {
        $property = new propertyEntity();
        $property->setName($name);
        $property->setValue($value);

        if ($classes) {
            $property->setClasses($classes);
        }

        if ($metaData) {
            $property->setMetadata($metaData);
        }

        return $property;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function setValue(mixed $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function setClasses(string|array $classes): static
    {
        $this->classes = Sanitize::htmlClassify($classes);

        return $this;
    }

    public function setMetadata($value): static
    {
        $this->metadata = $value ? json_encode($value) : null;

        return $this;
    }

    public function setCID($id): static
    {
        $this->cid = $id;

        return $this;
    }
}
