<?php

declare(strict_types=1);

namespace apexl\Io\modules\component\services;

use ArrayIterator;
use IteratorAggregate;
use Traversable;

abstract class bucket implements IteratorAggregate
{
    /**
     * @param  array<string, mixed>  $data
     */
    public function __construct(
        protected array $data = []
    ) {
    }

    public static function fromArray(array $data): static
    {
        return new static($data);
    }

    public function all(): array
    {
        return $this->data;
    }

    public function has(string $name): bool
    {
        return isset($this->data[$name]);
    }

    public function clear(string $name): void
    {
        unset($this->data[$name]);
    }

    public function clearAll(): void
    {
        $this->data = [];
    }

    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->data);
    }

    protected function _set(string $name, mixed $value): void
    {
        $this->data[$name] = $value;
    }

    protected function _get(string $name): mixed
    {
        return $this->data[$name] ?? null;
    }
}
