<?php

declare(strict_types=1);

namespace apexl\Io\modules\component\Factories;

use apexl\Io\modules\component\entities\ComponentProperty;
use DI\Container;

final readonly class ComponentPropertyFactory
{
    public function __construct(private Container $container) {}

    public function make(string $name, mixed $value): ComponentProperty
    {
        return $this->container->make(ComponentProperty::class, [
            'name' => $name,
            'value' => $value,
        ]);
    }
}
