<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateComponents extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('components')
            ->addColumn('pid', AdapterInterface::PHINX_TYPE_INTEGER, ['null' => true])
            ->addColumn('name', AdapterInterface::PHINX_TYPE_STRING, ['null' => false])
            ->addColumn('type', AdapterInterface::PHINX_TYPE_STRING, ['null' => false])
            ->addColumn('classes', AdapterInterface::PHINX_TYPE_STRING, ['null' => false, 'default' => ''])
            ->addIndex(['name'])
            ->create();
    }
}
