<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Service;

use apexl\Io\modules\cron\Exception\CronKeyException;
use apexl\Io\modules\cron\Interface\SuppliedCronKeyGetter;
use Psr\Http\Message\ServerRequestInterface;

final readonly class SuppliedCronKeyFromHeader implements SuppliedCronKeyGetter
{

    public function __construct(private CronConfig $config)
    {
    }

    /**
     * @throws CronKeyException
     */
    public function get(ServerRequestInterface $request): string
    {
        if (!$request->hasHeader($this->config->header)) {
            throw new CronKeyException('No cron key present', 422);
        }

        $supplied = $request->getHeader($this->config->header)[0];

        if (empty($supplied)) {
            throw new CronKeyException('Cron key empty', 422);
        }

        return $supplied;
    }
}
