<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Command;

use apexl\Io\includes\Hook;
use apexl\Io\modules\cron\cronModule;
use GO\Scheduler;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'cron:run', description: 'Run cron tasks')]
class RunCronTasksCommand extends Command
{
    public function __construct(readonly private Scheduler $scheduler)
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        Hook::processHook(cronModule::HOOK__REGISTER_CRON_TASK, $this->scheduler);

        $this->scheduler->run();

        return 0;
    }
}
