<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Service;

use apexl\Io\modules\cron\Exception\CronKeyException;
use apexl\Io\modules\cron\Interface\ConfiguredCronKeyGetter;
use Exception;

final readonly class ConfiguredCronKeyFromConfig implements ConfiguredCronKeyGetter
{
    public function __construct(private CronConfig $config)
    {
    }

    /**
     * @throws CronKeyException()
     */
    public function get(): string
    {
        try {
            if ($key = $this->config->key) {
                return $key;
            }

        } catch (Exception $e) {
            throw new CronKeyException(
                sprintf('Unable to get config: %s', $e->getMessage()),
                $e->getCode(),
                $e
            );
        }

        throw new CronKeyException('Sync key not configured in `app.sync.key`');
    }
}
