<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron;

use apexl\Config\Singleton as Config;
use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\cron\Controller\CronController;
use apexl\Io\modules\cron\Hook\ConsoleCommands;
use apexl\Io\modules\cron\Interface\ConfiguredCronKeyGetter;
use apexl\Io\modules\cron\Interface\SuppliedCronKeyGetter;
use apexl\Io\modules\cron\Middleware\AssertCronKey;
use apexl\Io\modules\cron\Service\ConfiguredCronKeyFromConfig;
use apexl\Io\modules\cron\Service\CronConfig;
use apexl\Io\modules\cron\Service\SuppliedCronKeyFromHeader;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;

class cronModule extends Module implements HasServicesInterface, HasHooksInterface
{
    public const HOOK__REGISTER_CRON_TASK = 'cron.register_cron_tasks';

    public function routes(): void
    {
        $this->route->post(
            'cron.run',
            '/cron/run',
            CronController::class,
            [
                System::getRegisteredService(AssertCronKey::class),
            ]
        );
    }

    public function addServices(): array
    {
        return [
            CronConfig::class => fn() => CronConfig::fromConfig(Config::getInstance()),
            ConfiguredCronKeyGetter::class => fn() => System::makeRegisteredService(ConfiguredCronKeyFromConfig::class),
            SuppliedCronKeyGetter::class => fn() => System::makeRegisteredService(SuppliedCronKeyFromHeader::class),
        ];
    }

    public function hooks(): array
    {
        return [
            ConsoleCommands::class,
        ];
    }
}
