<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Controller;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\cron\cronModule;
use GO\Scheduler;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final class CronController extends Controller
{
    public function __construct(readonly private Scheduler $scheduler)
    {
        parent::__construct();
    }

    public function __invoke(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        Hook::processHook(cronModule::HOOK__REGISTER_CRON_TASK, $this->scheduler);

        $this->scheduler->run();

        return System::asJson($response);
    }
}
