<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Hook;

use apexl\Io\collections\DaedalusCommandCollection;
use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\cron\Command\ListCronTasksCommand;
use apexl\Io\modules\cron\Command\RunCronTasksCommand;

final readonly class ConsoleCommands extends AbstractHook
{
    protected static function hooks(): array
    {
        return ['consoleCommands'];
    }

    public function __invoke(DaedalusCommandCollection $commands): DaedalusCommandCollection
    {
        $commands->add(RunCronTasksCommand::class);
        $commands->add(ListCronTasksCommand::class);

        return $commands;
    }
}
