<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Middleware;

use apexl\Io\includes\System;
use apexl\Io\modules\cron\Exception\CronKeyException;
use apexl\Io\modules\cron\Interface\ConfiguredCronKeyGetter;
use apexl\Io\modules\cron\Interface\SuppliedCronKeyGetter;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Slim\Psr7\Response;

readonly class AssertCronKey implements MiddlewareInterface
{
    public function __construct(
        private ConfiguredCronKeyGetter $configuredKeyGetter,
        private SuppliedCronKeyGetter $suppliedKeyGetter
    ) {}

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        try {
            $this->assertSuppliedKeyMatchesConfiguredKey($request);

            return $handler->handle($request);
        } catch (CronKeyException $exception) {
            return System::asJson(new Response(), [], $exception->getCode());
        }
    }

    /**
     * @throws CronKeyException
     */
    private function assertSuppliedKeyMatchesConfiguredKey(ServerRequestInterface $request): void
    {
        $suppliedKey = $this->suppliedKeyGetter->get($request);
        $configuredKey = $this->configuredKeyGetter->get();

        if ($suppliedKey !== $configuredKey) {
            throw new CronKeyException('Supplied key does not match configured key', 401);
        }
    }
}
