<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Service;

final readonly class CronConfig
{
    private const string DEFAULT__HEADER = 'X-Io-Cron-Key';

    public string $header;

    private function __construct(
        public string $key,
        ?string $header = null
    ) {
        $this->header = $header ?? self::DEFAULT__HEADER;
    }

    public static function fromConfig(object $config): CronConfig
    {
        return new self($config->app->cron->key, $config->app->cron->header ?? null);
    }
}
