<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Command;

use apexl\Io\includes\Hook;
use apexl\Io\modules\cron\cronModule;
use app\vendor\apexl\io\src\Io\modules\system\commands\DaedalusCommand;
use GO\Job;
use GO\Scheduler;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'cron:list', description: 'Run cron tasks')]
class ListCronTasksCommand extends DaedalusCommand
{
    public function __construct(readonly private Scheduler $scheduler)
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        Hook::processHook(cronModule::HOOK__REGISTER_CRON_TASK, $this->scheduler);

        foreach ($this->scheduler->getQueuedJobs() as $job) {
            $this->listJob($output, $job);
        }

        return 0;
    }

    private function listJob(OutputInterface $output, Job $job): void
    {
        $output->writeln(sprintf('%s (Due: %s)', $job->getId(), $job->isDue() ? 'YES' : 'NO'));
    }
}
