<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Service;

final readonly class CronConfig
{
    private const string DEFAULT__HEADER = 'X-Io-Cron-Key';

    private function __construct(
        public string $key,
        public string $header
    ) {}

    public static function fromConfig(): CronConfig
    {
        return new self(config('cron.key'), config('cron.header'));
    }
}
