<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Dto;

use apexl\dto\Dto;

final readonly class SchedulerCacheItemMetadata extends Dto
{
    public function __construct(public int $expires = 0)
    {}

    public static function create(int $ttl = 0): SchedulerCacheItemMetadata
    {
        return new SchedulerCacheItemMetadata($ttl === 0 ? 0 : time() + $ttl);
    }
}