<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Dto;

use apexl\dto\Dto;

final readonly class SchedulerCacheItem extends Dto
{
    public function __construct(public mixed $data, public SchedulerCacheItemMetadata $metadata) {}

    public static function create(mixed $data, int $ttl = 0): SchedulerCacheItem
    {
        return new SchedulerCacheItem($data, SchedulerCacheItemMetadata::create($ttl));
    }

    public function isExpired(?int $timestamp = null): bool
    {
        if ($this->metadata->expires === 0) {
            return false;
        }

        $timestamp = $timestamp ?? time();

        return $this->metadata->expires < $timestamp;
    }

    public function forStorage(): string {
        return serialize($this);
    }
}