<?php

declare(strict_types=1);

namespace apexl\Io\modules\cron\Service;

use apexl\Io\includes\System;
use apexl\Io\modules\cron\Dto\SchedulerCacheItem;
use Symfony\Contracts\Cache\CacheInterface;

final readonly class SchedulerCache implements CacheInterface
{
    function key(string $key): string
    {
        return sprintf('scheduler_cache__%s', $key);
    }

    public function get(string $key, callable $callback, ?float $beta = null, ?array &$metadata = null): mixed
    {
        $key = $this->key($key);

        if (System::hasVariable($key)) {
            /** @var SchedulerCacheItem $data */
            $data = unserialize(System::getVariable($key));
            if (!$data->isExpired()) {
                return $data->data;
            }
        }

        $value = $callback();
        $this->set($key, $value, $metadata);

        return $value;
    }

    public function delete(string $key): bool
    {
        if (System::hasVariable($key)) {
            System::deleteVariable($key);

            return true;
        }

        return false;
    }

    private function set(string $key, mixed $value, ?array $metadata = null): void
    {
        if (!$metadata) {
            $metadata = [];
        }

        System::setVariable(
            $key,
            SchedulerCacheItem::create($value, $metadata['ttl'] ?? 0)->forStorage()
        );
    }
}